#pragma once

// structure for storing attribute-name pairs
struct SAttribute
{
	wstring Name;
	wstring Value;
};

//! Enumeration of all supported source text file formats 
enum ETEXT_FORMAT
{
	ETF_ASCII,
	ETF_UTF8,
	ETF_UTF16_BE,
	ETF_UTF16_LE,
	ETF_UTF32_BE,
	ETF_UTF32_LE,
};


//! Enumeration for all xml nodes which are parsed by IrrXMLReader
enum EXML_NODE
{
	EXN_NONE,
	EXN_ELEMENT,
	EXN_ELEMENT_END,
	EXN_TEXT,
	EXN_COMMENT,
	EXN_CDATA,
	EXN_UNKNOWN
};

class XMLReader
{
public:
	WCHAR filename[100];
	XMLReader();
	~XMLReader(void);
	void LoadXML(const WCHAR* srcbuf, ETEXT_FORMAT in_SourceFormat = ETF_UTF16_LE, ETEXT_FORMAT in_TargetFormat = ETF_UTF16_LE);
	bool read();
	EXML_NODE XMLReader::getNodeType();
	int XMLReader::getAttributeCount();
	const WCHAR* getAttributeName(int idx);
	const WCHAR* getAttributeValue(int idx);
	const WCHAR* getAttributeValue(const WCHAR* name);
	const WCHAR* getAttributeValue(const WCHAR* name, const WCHAR * defval);
	const WCHAR* getAttributeValueSafe(const WCHAR* name);
	int getAttributeValueAsInt(const WCHAR* name);
	bool getAttributeValueAsBool(const WCHAR* name);
	int getAttributeValueAsInt(int idx);
	float getAttributeValueAsFloat(const WCHAR* name);
	float getAttributeValueAsFloat(int idx);
	const WCHAR* getNodeName();
	const WCHAR* getNodeData();
	wstring getSubNodeData();
	bool isEmptyElement();
	ETEXT_FORMAT getSourceFormat();
	ETEXT_FORMAT getParserFormat();
	void restart();
	int GetOffset();
	int GetSize();
	SAttribute* getAttributeByName(const WCHAR* name);
private:
	void parseCurrentNode();
	bool setText(WCHAR* start, WCHAR* end);
	void ignoreDefinition();
	void parseComment();
	void parseOpeningXMLElement();
	void parseClosingXMLElement();
	bool parseCDATA();
	wstring replaceSpecialCharacters( wstring& origstr);
	//bool readFile(IFileReadCallBack* callback);
	inline bool isLittleEndian(ETEXT_FORMAT f);
	bool isWhiteSpace(WCHAR c);
	void createSpecialCharacterList();
	bool equalsn(const WCHAR* str1, const WCHAR* str2, int len);

public:
	WCHAR* TextBegin;        // start of text to parse
	
private:
	WCHAR* TextData;         // data block of the text file
	WCHAR* P;                // current point in text to parse
	unsigned int TextSize;       // size of text to parse in characters, not bytes

	EXML_NODE CurrentNodeType;   // type of the currently parsed node
	ETEXT_FORMAT SourceFormat;   // source format of the xml file
	ETEXT_FORMAT TargetFormat;   // output format of this parser

	wstring NodeName;    // name of the node currently in
	wstring EmptyString; // empty string to be returned by getSafe() methods

	bool IsEmptyElement;       // is the currently parsed node empty?

#pragma warning(disable:4251)
	vector<wstring> SpecialCharacters; // see createSpecialCharacterList()
	vector<SAttribute> Attributes; // attributes of current element
#pragma warning(default:4251)
};

XMLReader* LoadConfigFile(wstring configfile, wstring path = L"");
bool StartAttribute(XMLReader* xml, wstring attribute);
bool EndAttribute(XMLReader* xml, wstring attribute);
void FreeXMLAndText(XMLReader * xml);
void FreeXML(XMLReader * xml);
XMLReader* XMLFromString(wstring & input);

